import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class EchoServer extends Thread {
    private ServerSocket serverSocket;
    private Socket clientSocket;
    private PrintWriter out;
    private BufferedReader in;
    private Integer port;

    EchoServer(Integer port) {
        this.port = port;
    }

    @Override
    public void run() {
        try {
            startServer(this.port);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void startServer(int port) throws IOException {
        System.out.println("Create socket");
        serverSocket = new ServerSocket(port);
        System.out.println("Waitng for client");
        clientSocket = serverSocket.accept();
        System.out.println("Connection accepted");
        out = new PrintWriter(clientSocket.getOutputStream(), true);
        in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));

        String inputLine;
        System.out.println("Waitng for message");
        while ((inputLine = in.readLine()) != null) {
            System.out.println("Recive message: " + inputLine);
            if (".".equals(inputLine)) {
                out.println("good bye");
                break;
            }
            out.println(inputLine);
        }
    }

    public void stopServer() throws IOException {
        in.close();
        out.close();
        serverSocket.close();
    }

    public static void main(String[] args) throws IOException {
        EchoServer server=new EchoServer(6666);
        server.start();
    }
}