package CommandLine;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Scanner;

@Getter
@Setter
@NoArgsConstructor
public class CommandLineController {
    private String nickname;
    private Scanner scanner = new Scanner(System.in);

    public void askNickname() {
        System.out.println(Ansi.Green.and(Ansi.Bold).colorize("Enter username: "));
        nickname = scanner.nextLine();
    }
    public void displayMessage(String message) {
        LocalDateTime myDateObj = LocalDateTime.now();
        DateTimeFormatter myFormatObj = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
        String formattedDate = myDateObj.format(myFormatObj);

        // display of [formated date] nickname: message
        System.out.println(
                Ansi.Bold.and(Ansi.Magenta).format("[%s] ", formattedDate) +
                Ansi.Green.format("%s: ",getNickname()) +
                Ansi.Yellow.colorize(message)
        );
    }
}
